//
//  DSColorView.h
//  Dispatch
//
//  Created by Keith Duncan on 21/07/2009.
//  Copyright 2009 Realmac Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface RMColorView : NSView

/*!
	\brief
	This is drawn with NSCompositeSourceOver
 */
@property (copy, nonatomic) NSColor *backgroundColor;

/*!
	\brief
	This string should be a class selector sent to NSColor to determine the color to draw.
	This should be set using the User Defined Runtime Attributes feature of IB in 10.6.
 
	This will be of more use for debug views i.e. @"redColor".
 */
- (void)setBackgroundColorName:(NSString *)value;

/*!
	\brief
	Allows you to disable the forwarding of events.
	Defaults to NO.
 */
@property (assign, nonatomic) BOOL forwardsEvents;

@end
